IncludeFile "Screen3DRequester.pbi"

Procedure ScreenError(Msg$)
  CloseScreen()
  MessageRequester("FATAL ERROR",Msg$,#MB_ICONERROR)
  End
EndProcedure

DefType.f KeyX, KeyY, MouseX, MouseY

Add3DArchive("Danilo3D_Data.zip", #PB_3DArchive_Zip)

If InitEngine3D()=0
   MessageRequester("FATAL ERROR", "Cant initialize 3D engine", #MB_ICONERROR) : End
EndIf
If InitSprite()=0 Or InitKeyboard()=0 Or InitMouse()=0
   MessageRequester("FATAL ERROR", "Cant initialize DirectX", #MB_ICONERROR) : End
EndIf
 
If Screen3DRequester()

   If LoadWorld("maps\Danilo1.bsp")=0
     ScreenError("Cant load world !")
   EndIf

   If LoadMesh   (0,"robot.mesh")=0
     ScreenError("Cant load mesh !")
   EndIf

   If LoadTexture(0, "rallycar.jpg")=0
     ScreenError("Cant load mesh texture !")
   EndIf

   
   If CreateMaterial(0,TextureID(0))=0
     ScreenError("Cant create material !")
   EndIf

   If CreateEntity(0,MeshID(0),MaterialID(0))=0
     ScreenError("Cant create entity !")
   EndIf

   
   AnimateEntity(0, "Walk")
   EntityLocate(0,0,90,-95)
   RotateEntity(0,90,90,90)

   If CreateCamera(0, 0, 0, 100, 100)=0
     ScreenError("Cant create camera 1 !")
   EndIf

   
   CameraLocate(0,-200,-180,0)
   RotateCamera(0,-45,0,0)

   If CreateCamera(1,0,0,30,30)=0
     ScreenError("Cant create camera 2 !")
   EndIf

   CameraLocate(1,90,-180,0)

   Repeat

     Screen3DEvents()

     If ExamineKeyboard()
        If movement < 170
           MoveEntity(0,1,0,0)
           movement + 1
        ElseIf movement < 200 And movement > 169
           MoveEntity(0,1,0,0)
           movement + 1
           RotateEntity(0,-6,0,0)
        ElseIf movement => 200 And movement < 370
           MoveEntity(0,-1,0,0)
           movement + 1
        ElseIf movement < 400 And movement > 369
           MoveEntity(0,-1,0,0)
           movement + 1
           RotateEntity(0,6,0,0)
        Else
           movement = 0
        EndIf


        If KeyboardPushed(#PB_Key_Left)
           KeyX = -1
        ElseIf KeyboardPushed(#PB_Key_Right)
           KeyX = 1
        Else
           KeyX = 0
        EndIf

        If KeyboardPushed(#PB_Key_Up)
           KeyY = -1
        ElseIf KeyboardPushed(#PB_Key_Down)
           KeyY = 1
        Else
           KeyY = 0
        EndIf
     EndIf

     If ExamineMouse()
        MouseX =  -MouseDeltaX()
        MouseY =  -MouseDeltaY()
     EndIf

     RotateCamera(0, MouseX, MouseY, 0)
     MoveCamera(0, KeyX*50, 0, KeyY*50)

     If CameraX(0) >  245 : CameraLocate(0, 245,CameraY(0),CameraZ(0)) : EndIf
     If CameraX(0) < -245 : CameraLocate(0,-245,CameraY(0),CameraZ(0)) : EndIf
     If CameraY(0) >  176 : CameraLocate(0,CameraX(0), 176,CameraZ(0)) : EndIf
     If CameraY(0) < -176 : CameraLocate(0,CameraX(0),-176,CameraZ(0)) : EndIf
     If CameraZ(0) <> -10 : CameraLocate(0,CameraX(0),CameraY(0),0)    : EndIf

     RenderWorld()

     If StartDrawing(ScreenOutput())
       DrawingMode(1): FrontColor($FF,$FF,$00)
       Locate(10,10)
       DrawText("Mouse and cursor keys to move. ESC to exit..")
       ;Locate(10,25)
       ;DrawText("X: "+Str(CameraX(0)))
       ;Locate(10,40)
       ;DrawText("Y: "+Str(CameraY(0)))
       ;Locate(10,55)
       ;DrawText("Z: "+Str(CameraZ(0)))
       StopDrawing()
     EndIf

     ; SCREENSHOT
     If KeyboardPushed(#PB_Key_F1)
       GrabSprite(1,0,0,ScreenWidth,ScreenHeight,#PB_Sprite_Memory)
       SaveSprite(1,"Danilo3D-1_SS"+StrU(SS,#LONG)+".bmp")
       SS + 1
     EndIf
       
     FlipBuffers()
     
     Delay(1)
     
   Until KeyboardPushed(#PB_Key_Escape) Or Quit = 1
EndIf 
; ExecutableFormat=Windows
; Executable=Danilo3D-1.exe
; DisableDebugger
; EOF