Procedure ScreenError(Msg$)
  CloseScreen()
  MessageRequester("FATAL ERROR",Msg$)
  End
EndProcedure



If InitEngine3D() And InitSprite() And InitKeyboard() 
  If OpenWindow(0,0,0,640,480,#PB_Window_SystemMenu|#PB_Window_ScreenCentered,"Mesh Test")=0
    MessageRequester("FATAL ERROR", "Cant open window !"):End
  EndIf

  If OpenWindowedScreen(WindowID(),0,0,640,480,0,0,0)=0
    MessageRequester("FATAL ERROR", "Cant open screen !"):End
  EndIf

  If CreateMesh(0)=0
     ScreenError("Cant create mesh !")
  EndIf

  SetMeshData(0, 0, ?CubeVertices          , 4) 
  SetMeshData(0, 1, ?CubeFacesIndexes      , 2) 
  SetMeshData(0, 2, ?CubeTextureCoordinates, 4) 
    
  If CreateTexture(0,100,100)=0
     ScreenError("Cant create texture !")
  EndIf

  If StartDrawing(TextureOutput(0)) 
    Box(0,0,100,100,$00FFFF) 
    StopDrawing()
  EndIf

  If CreateEntity(0, MeshID(0), CreateMaterial(0, TextureID(0)))=0
     ScreenError("Cant create entity !")
  EndIf
    
  ScaleEntity(0, 3, 3, 3) 
    
  If CreateCamera(0, 0, 0, 100, 100)=0
     ScreenError("Cant create camera !")
  EndIf

  CameraLocate(0,0,0,10) 
    
  Repeat 
    ExamineKeyboard() 
    Select WindowEvent() 
      Case #PB_Event_CloseWindow 
        Quit = #TRUE 
    EndSelect 

    RotateEntity(0, 1, 0, 1) 
    
    ClearScreen(0,0,0) 
    RenderWorld() 
    FlipBuffers() 
  Until KeyboardPushed(#PB_Key_Escape) Or Quit 
Else 
  MessageRequester("Error", "Cant init DirectX 3D Engine !") 
EndIf 
  
End 


DataSection 

  CubeVertices: 
    Data.f 0, 0, 0 ; Vertex index 0 
    Data.f 1, 0, 0 ; Vertex index 1 
    Data.f 1, 1, 0 ; Vertex index 2 
    Data.f 0, 1, 0 ; Vertex index 3 

  CubeFacesIndexes: 
    Data.w 0, 1, 2 ; bottom face (clockwise as it's reversed...) 
    Data.w 2, 3, 0 

  CubeTextureCoordinates: 
    Data.f 2.63, 0.63 ; Vertex 0 
    Data.f 0.63, 2.63 ; Vertex 1 
    Data.f 2.63, 0.63 ; Vertex 2 
    Data.f 0.63, 2.63 ; Vertex 3 
      
EndDataSection 

; ExecutableFormat=Windows
; Executable=MeshManual1.exe
; DisableDebugger
; EOF