Procedure.f GSin(Degree.f)
   ProcedureReturn Sin(Degree*(2*3.14159265/360))
EndProcedure


Procedure CheckCollision()
Shared crouching, jumping, jumpcounter.f
     If CameraX(0) >  290 : CameraLocate(0,  290,CameraY(0),CameraZ(0)) : EndIf
     If CameraX(0) < -5200: CameraLocate(0,-5200,CameraY(0),CameraZ(0)) : EndIf


     If CameraX(0) <= -2028 And CameraX(0) > -2463
        If CameraY(0) < -94 Or CameraY(0) > 130
           If CameraX(0) > -2200
              CameraLocate(0,-2028,CameraY(0),CameraZ(0))
           Else
              CameraLocate(0,-2463,CameraY(0),CameraZ(0))
           EndIf
        Else
           If CameraY(0) < -82
              CameraLocate(0,CameraX(0),-82,CameraY(0))
           ElseIf CameraY(0) > 118
              CameraLocate(0,CameraX(0),118,CameraY(0))
           EndIf
        EndIf
     EndIf

     If CameraX(0) <= -2463
        ; Big room
        If CameraY(0) =>  1247 : CameraLocate(0,CameraX(0), 1247,CameraZ(0)) : EndIf
        If CameraY(0) <= -1309 : CameraLocate(0,CameraX(0),-1309,CameraZ(0)) : EndIf
     EndIf

     If CameraX(0) <= 290 And CameraX(0) => -2028
        If CameraY(0) >  310 : CameraLocate(0,CameraX(0), 310,CameraZ(0)) : EndIf
        If CameraY(0) < -277 : CameraLocate(0,CameraX(0),-277,CameraZ(0)) : EndIf
     EndIf

     ; z
     If CameraX(0) > -70
        CameraLocate(0,CameraX(0),CameraY(0),-130)
     ElseIf CameraX(0) > -100
        CameraLocate(0,CameraX(0),CameraY(0),-116)
     ElseIf CameraX(0) > -130
        CameraLocate(0,CameraX(0),CameraY(0),-102)
     ElseIf CameraX(0) > -160
        CameraLocate(0,CameraX(0),CameraY(0), -88)
     ElseIf CameraX(0) > -190
        CameraLocate(0,CameraX(0),CameraY(0), -74)
     ElseIf CameraX(0) > -220
        CameraLocate(0,CameraX(0),CameraY(0), -60)
     ElseIf CameraX(0) > -250
        CameraLocate(0,CameraX(0),CameraY(0), -46)
     ElseIf CameraX(0) > -280
        CameraLocate(0,CameraX(0),CameraY(0), -32)
     ElseIf CameraX(0) > -310
        CameraLocate(0,CameraX(0),CameraY(0), -18)
     Else
        CameraLocate(0,CameraX(0),CameraY(0),  10)
     EndIf
     
     If jumping
        jumpcounter + 6.3
        If jumpcounter => 180.0
           jumpcounter = 0.0
           jumping = 0
        EndIf
        If jumpcounter
           CameraLocate(0,CameraX(0),CameraY(0),CameraZ(0)+GSin(jumpcounter)*80)
        EndIf
     EndIf
     
     If crouching
        CameraLocate(0,CameraX(0),CameraY(0),CameraZ(0)-45)
     EndIf
     
EndProcedure


Procedure ScreenError(Msg$)
  CloseScreen()
  MessageRequester("FATAL ERROR",Msg$,#MB_ICONERROR)
  End
EndProcedure





IncludeFile "Screen3DRequester.pbi"

DefType.f KeyX, KeyY, MouseX, MouseY

Add3DArchive("Danilo3D_Data.zip", #PB_3DArchive_Zip)

If InitEngine3D()=0
   MessageRequester("FATAL ERROR", "Cant initialize 3D engine", #MB_ICONERROR) : End
EndIf
If InitSprite()=0 Or InitKeyboard()=0 Or InitMouse()=0
   MessageRequester("FATAL ERROR", "Cant initialize DirectX", #MB_ICONERROR) : End
EndIf

If Screen3DRequester()
      
   If LoadWorld("maps\Danilo2.bsp")=0
     ScreenError("Cant load world !")
   EndIf

   If CreateCamera(0, 0, 0, 100, 100)=0
     ScreenError("Cant create camera !")
   EndIf

   CameraLocate(0,250,-220,-130)
   RotateCamera(0,45,0,0)

   Fog($080808,1,3000,3200)

   Repeat

     Screen3DEvents()

     If ExamineKeyboard()

        If KeyboardPushed(#PB_Key_Left)
           KeyX = -0.8
        ElseIf KeyboardPushed(#PB_Key_Right)
           KeyX = 0.8
        Else
           KeyX = 0
        EndIf

        If KeyboardPushed(#PB_Key_Up)
           KeyY = -0.8
        ElseIf KeyboardPushed(#PB_Key_Down)
           KeyY = 0.8
        Else
           KeyY = 0
        EndIf

        If KeyboardPushed(#PB_Key_Space) And crouching = 0
           jumping = 1
        EndIf

        If KeyboardPushed(#PB_Key_C) And jumping = 0
           crouching = 1
        EndIf
        If KeyboardReleased(#PB_Key_C) And jumping = 0
           crouching = 0
        EndIf
     EndIf

     If ExamineMouse()
        MouseX = -MouseDeltaX()
        MouseY = -MouseDeltaY()
     EndIf

     RotateCamera(0, MouseX, MouseY, 0)
     MoveCamera(0, KeyX*50, 0, KeyY*50)

     CheckCollision()

     RenderWorld()

     If StartDrawing(ScreenOutput())
       DrawingMode(1): FrontColor($FF,$FF,$00)
       Locate(10,10)
       DrawText("Mouse and cursor keys to move. ESC to exit..")
       Locate(10,25)
       DrawText("[Space] = Jump, [C] = Crouch")
       ;Locate(10,50)
       ;DrawText("X: "+Str(CameraX(0)))
       ;Locate(10,65)
       ;DrawText("Y: "+Str(CameraY(0)))
       ;Locate(10,80)
       ;DrawText("Z: "+Str(CameraZ(0)))
       StopDrawing()
     EndIf

     ; SCREENSHOT
     If KeyboardPushed(#PB_Key_F1)
       GrabSprite(1,0,0,ScreenWidth,ScreenHeight,#PB_Sprite_Memory)
       SaveSprite(1,"Danilo3D-2_SS"+StrU(SS,#LONG)+".bmp")
       SS + 1
     EndIf
       
     FlipBuffers()
     
     Delay(1)
     
   Until KeyboardPushed(#PB_Key_Escape) Or Quit = 1
EndIf 
; ExecutableFormat=Windows
; Executable=Danilo3D-2.exe
; DisableDebugger
; EOF