If InitEngine3D() And InitSprite() And InitKeyboard() 
  OpenWindow(0,0,0,640,480,#PB_Window_SystemMenu|#PB_Window_ScreenCentered,"3D Mesh Test") 
  OpenWindowedScreen(WindowID(),0,0,640,480,0,0,0) 
  BigFont = LoadFont(1,"Arial",38) 

    CreateTexture(0,100,100) 
    StartDrawing(TextureOutput(0)) 
      Box(0,0,100,100,$00FFFF) 
      LineXY(0,0,100,100,$000000) 
      LineXY(100,0,0,100,$000000) 
      FrontColor($00,$00,$FF) 
      DrawingMode(1) 
      DrawingFont(BigFont) 
      Locate(0,0) 
      DrawText("123") 
    StopDrawing()
    
    CreateMaterial(0, TextureID(0))

    ; Viereck 1
    CreateMesh(1) 
    SetMeshData(1,#PB_Mesh_Vertices     ,?Ecken            , 4) ; 4 Ecken
    SetMeshData(1,#PB_Mesh_Triangles    ,?Viereck_1        , 2) ; 2 Dreicke
    SetMeshData(1,#PB_Mesh_UVCoordinates,?TexturKoordinaten, 4)

    CreateEntity(1, MeshID(1), MaterialID(0)) 


    ; Viereck 2
    CreateMesh(2) 
    SetMeshData(2,#PB_Mesh_Vertices     ,?Ecken            , 4) ; 4 Ecken
    SetMeshData(2,#PB_Mesh_Triangles    ,?Viereck_2        , 2) ; 2 Dreiecke
    SetMeshData(2,#PB_Mesh_UVCoordinates,?TexturKoordinaten, 4)

    CreateEntity(2, MeshID(2), MaterialID(0)) 


    ; Viereck 3
    CreateMesh(3) 
    SetMeshData(3,#PB_Mesh_Vertices     ,?Ecken            , 4) ; 4 Ecken
    SetMeshData(3,#PB_Mesh_Triangles    ,?Viereck_3        , 4) ; 4 Dreiecke (Vorder- und Rueckseite)
    SetMeshData(3,#PB_Mesh_UVCoordinates,?TexturKoordinaten, 4)

    CreateEntity(3, MeshID(3), MaterialID(0)) 


    MoveEntity(1,-3,0,0)
    MoveEntity(3, 3,0,0)
    
    CreateCamera(0, 0, 0, 100, 100) 
    CameraLocate(0,0,0,10) 
    
    Repeat 
      ExamineKeyboard() 
      Select WindowEvent() 
        Case #PB_Event_CloseWindow 
          Quit = #TRUE 
      EndSelect 

      RotateEntity(1, 1, 1, 0)
      RotateEntity(2, 1, 1, 0)
      RotateEntity(3, 1, 1, 0)
      
      ClearScreen(0,0,0) 
      RenderWorld() 
      FlipBuffers() 
    Until KeyboardPushed(#PB_Key_Escape) Or Quit 
Else 
  MessageRequester("Error", "Cant init DirectX 3D Engine",0) 
EndIf 
  
End 


DataSection 

  Ecken: 
    Data.f -1, -1,  0 ; Ecke 0             3-----2
    Data.f  1, -1,  0 ; Ecke 1             |  .  |
    Data.f  1,  1,  0 ; Ecke 2             |     |
    Data.f -1,  1,  0 ; Ecke 3             0-----1

  TexturKoordinaten: 
    Data.f 0.0, 0.0 ; Vertex 0
    Data.f 1.0, 0.0 ; Vertex 1
    Data.f 1.0, 1.0 ; Vertex 2
    Data.f 0.0, 1.0 ; Vertex 3

  Viereck_1: 
    Data.w 0, 1, 2  ; Dreieck 1 besteht aus den Ecken 0, 1 und 2
    Data.w 2, 3, 0  ; Dreieck 2 besteht aus den Ecken 2, 3 und 0
                    ; = 1 Viereck

  Viereck_2:
    Data.w 0, 3, 2  ; Dreieck 1 besteht aus den Ecken 0, 3 und 2
    Data.w 2, 1, 0  ; Dreieck 2 besteht aus den Ecken 2, 1 und 0
                    ; = 1 Viereck

  Viereck_3:
    Data.w 0, 1, 2  ; Dreieck 1 besteht aus den Ecken 0, 1 und 2
    Data.w 2, 3, 0  ; Dreieck 2 besteht aus den Ecken 2, 3 und 0
                    ; = 1 Viereck Vorderseite
    Data.w 0, 3, 2  ; Dreieck 1 besteht aus den Ecken 0, 3 und 2
    Data.w 2, 1, 0  ; Dreieck 2 besteht aus den Ecken 2, 1 und 0
                    ; = 1 Viereck Rueckseite


EndDataSection
; ExecutableFormat=Windows
; Executable=MeshManual4.exe
; DisableDebugger
; EOF